﻿/*
	[] currentMovements			Array of promises, which represent movement commands
	[] moveTimeout					Tracks interval-ID's for setTimeout() created by movement commands
	() stopMoveCommands			Interrupts current movement  +  erases all timeout ID's
	() killWait							alias for:  stopMoveCommands()
	
	[] currentMovements
	[] moveTimeout
	() stopMoveCommands
	() killWait
*/



// enable movement waiting
currentMovements = [];
currentMovements.add = function( prom ){
	for(var i=currentMovements.length-1; i>=0; i--){
		// abort if this promise is already in this list
		if(currentMovements[i] === prom)	return;
	}// for:  each existing movement promise
	
	currentMovements.push( prom );
}// add()
currentMovements.remove = function( prom ){
	for(var i=currentMovements.length-1; i>=0; i--){
		if(currentMovements[i] === prom){
			currentMovements.splice( i,1 );
			break;
		}
	}// for:  each existing movement promise
}// remove()
currentMovements.cancelAll = function( abortValue ){
	for(var i=currentMovements.length-1; i>=0; i--){
		currentMovements[i].abort( abortValue );
	}// for:  each existing movement promise
}// cancelAll()



// _____________________________________________________________________________________________________________
// enable movement events
// player
//slideX;		// These are movement tweens for this sprite. They only exist during movements.
//slideY;
//lastMove = {};
//AsBroadcaster.initialize(lastMove);
// move wait tracking
moveTimeout = [];
moveTimeout.addTimeout = function( timeoutID ){
	var newTimeout = {
		timeoutID:timeoutID
	}// newSound object
	this.push( newTimeout );
}// addSound()
moveTimeout.remove = function( timeoutID ){
	for(var t=this.length-1; t>=0; t--){
		if(this[t].timeoutID == timeoutID){
			clearTimeout( this[t].timeoutID );
			this.splice(t, 1);
		}// if:  match found
	}// for:  each move timeout
}// remove()
moveTimeout.exists = function( timeoutID ){
	var output = false;
	for(var t=this.length-1; t>=0; t--){
		if(this[t].timeoutID == timeoutID){
			output = true;
			break;
		}// if:  match found
	}// for:  each move timeout
	return output;
}// remove()
moveTimeout.removeAll = function( abortValue ){
	var abortValue = arguments[0];
	for(var t=moveTimeout.length-1; t>=0; t--){
		clearTimeout( moveTimeout[t].timeoutID );
		moveTimeout[t].timeoutID = null;
		moveTimeout.splice(t, 1);
	}// for:  each move timeout
	
	for(var nam in scripts){
		if(scripts[nam].timeoutID == null)  return;
		clearTimeout( scripts[nam].timeoutID );
		scripts[nam].timeoutID = null;
	}
	
	currentMovements.cancelAll( abortValue );
}// removeAll()



// able to interrupt movements
stopMoveCommands = function( abortValue ){
	var abortValue = arguments[0];
	// clear the timeout  (prevents next script command)
	moveTimeout.removeAll( abortValue );
	// prematurely trigger complete()
	slideY.onMotionFinished();
}// stopMoveCommands()



killWait = stopMoveCommands;
stopMoving = stopMoveCommands;



// ________________________________________________________________________________
react.to("unload").then = function(){
	stopMoveCommands( false );		// abort & fail movements
	// clear all move command timeouts
	for(var nam in _this){
		if(_this[nam].timeoutID){
			clearTimeout( _this[nam].timeoutID );				// "wait" defines this
			_this[nam].timeoutID = null;								// allow commands to see that it's been cleared
		}// if:  match found
	}// for:  each move timeout
}// onUnload()